import axios from "axios";
import { NextResponse } from "next/server";
import { env } from "process";

export async function POST(req: Request) {
  try {
    
    const { email, language } = (await req.json()) as {
      email: string;
      language:string
    };
   
    const response = await axios.post(process.env.API_URL+'/forgot-password', {
      email_address:email,     
      language:language
    });

    // return null;
    if(response.data.status !== 200){
      let error_msg:any = '';

      for (const key in response.data.message) {
        if (response.data.message.hasOwnProperty(key)) {
          error_msg += response.data.message[key];
        }
      }


      return new NextResponse(
        JSON.stringify({
          status: "error",
          message: error_msg,
        }),
        { status: 400 }
      );
    }

 return new NextResponse(
        JSON.stringify({
          ok: "ok"
        }),
        { status: 200 }
      );
     
    

  } catch (error: any) {
    return new NextResponse(
      JSON.stringify({
        status: "error",
        message: error.message,
      }),
      { status: 500 }
    );
  }
}
