// // app/i18n.ts
// import { notFound } from 'next/navigation';
// import { getRequestConfig } from 'next-intl/server'; // Updated import

// export const locales = ['fr', 'en'] as const;
// export type Locale = (typeof locales)[number];
// export const defaultLocale = 'fr';

// export function isLocale(locale: string): locale is Locale {
//   return locales.includes(locale as Locale);
// }

// // Required default export
// export default getRequestConfig(async ({ locale }) => {
//   if (!isLocale(locale)) notFound();

//   return {
//     messages: (await import(`../../languages/${locale}.json`)).default,
//     timeZone: 'Europe/Paris',
//     locale
//   };
// });

// // Helper functions
// export async function getMessages(locale: Locale) {
//   return (await import(`../../languages/${locale}.json`)).default;
// }



import { notFound } from 'next/navigation';
import { getRequestConfig } from 'next-intl/server';

export const locales = ['fr', 'en'] as const;
export type Locale = (typeof locales)[number];
export const defaultLocale: Locale = 'fr';

// Enhanced type guard that handles undefined
export function isLocale(locale: string | undefined): locale is Locale {
  return typeof locale === 'string' && locales.includes(locale as Locale);
}

export default getRequestConfig(async ({ requestLocale }) => {
  const locale = await requestLocale;
  
  // Now properly handles string | undefined
  if (!isLocale(locale)) {
    notFound();
  }

  return {
    messages: (await import(`../../languages/${locale}.json`)).default,
    timeZone: 'Europe/Paris',
    locale
  };
});

// Helper function remains type-safe
export async function getMessages(locale: Locale) {
  return (await import(`../../languages/${locale}.json`)).default;
}