'use client'
import React, { createContext, useContext, useState, ReactNode, useEffect } from 'react';
import { signOut, useSession } from "next-auth/react";
import { getOrganizerEventStats } from '../lib/userDataCalls';
import { getEventListByStatus } from '../lib/eventsCalls';
import { MapStateProvider } from './MapStateProvider';
import Cookies from 'js-cookie';
import { useRouter } from "next/navigation";

type ContextType = {
  lang: string;
  setLang: (lang: string) => void;
  eventStats: EventStatsData | null;
  setEventStats: (data: EventStatsData | null) => void;
  fetchDataManually: () => void;
  fetchOnlineEventDataManually:() =>void;
  customTriggerForOnlineEvent: number,
  CustomScrollTrigger:() =>void;
  acceptCookies:string | null | undefined;
  SetAcceptCookies:(value:any) =>void;
};

const GlobalContext = createContext<ContextType | undefined>(undefined);

export const useGlobalContext:any = () => {
  const context = useContext(GlobalContext);
  if (!context) {
    throw new Error('useGlobalContext must be used within a GlobalContextProvider');
  }
  return context;
};

type GlobalContextProviderProps = {
  children: ReactNode;
};

interface EventStatsData {
  savedEvents: number;
  onlineEvent: number;
  pastEvents: number;
}

export const GlobalContextProvider = ({ children }: GlobalContextProviderProps) => {
  const [lang, setLang] = useState('');
  const { data: session, status } = useSession();

  const user = session?.user as {
    name: string;
    email: string;
    image: string;
    id: number;
    randomKey: string;
  };

  const [eventStats, setEventStats] = useState<EventStatsData | null>(null);
  const [customTrigger, setCustomTrigger] = useState<number>(0);

  
  const [customTriggerForOnlineEvent, setCustomTriggerForOnlineEvent] = useState<number>(0);
  const router = useRouter();
  useEffect(() => {
    const getData = async () => {
      if (session?.user) {
        const data = await getOrganizerEventStats(user?.id, user?.randomKey);
        if(data=='token_expired'){
          const currLang  =   Cookies.get('NEXT_LOCALE');
          localStorage.removeItem("user_data");
          await signOut();
          if(currLang=='fr'){
            router.push('/login');
          }else{
            router.push('/en/login');
          }
        }
        setEventStats(data);
      }
    };
    getData();
  }, [session,customTrigger,user?.id, user?.randomKey]);

  const fetchDataManually = () => {
    setCustomTrigger(prevTrigger => prevTrigger + 1); 
  };

  const fetchOnlineEventDataManually = () => {
    setCustomTriggerForOnlineEvent(prevTrigger => prevTrigger + 1); 
  };


  const [scrollCustom, setScrollCustom] = useState<number>(0)
  const scrollToTop = () => {
    // console.log('scrollCustom Done');
    window.scrollTo(0, 0);
  };

  useEffect(() => {
    // console.log('scrollCustom');
    scrollToTop();
  },[scrollCustom]);

  const CustomScrollTrigger = () => {
    setScrollCustom(prevTrigger => prevTrigger + 1); 
  };

  // acceptCookies:string | null;
  // SetAcceptCookies:() =>void
  const [acceptCookies,setUpCookies] = useState<string | null | undefined>(Cookies.get('acceptCookies'));

 
  
  const SetAcceptCookies = (value:any) => {
    // Your logic to set up cookies with the provided value
    // console.log(`Setting up cookies with value: ${value}`);
    setUpCookies(value); // Update the context state or perform other actions
  };

  const contextValue: ContextType = {
    lang,
    setLang,
    eventStats,
    setEventStats,
    fetchDataManually,
    fetchOnlineEventDataManually,
    customTriggerForOnlineEvent,
    CustomScrollTrigger,
    acceptCookies,
    SetAcceptCookies
  };

  return (
    <GlobalContext.Provider value={contextValue}>
      <MapStateProvider>
      {children}
     </MapStateProvider>
    </GlobalContext.Provider>
  );
};