import 'server-only'
import type { Locale } from '../../i18n-config'

const dictionaries = {
  fr: () => import('../languages/fr.json').then((module) => module.default),
  en: () => import('../languages/en.json').then((module) => module.default)
}

export const getDictionary = async (locale: Locale) => dictionaries[locale]()