
import { CommuneData,CommuneResponse,EventData } from "../../../utils/interface";

export async function getCommuneData(
  commune: string
): Promise<CommuneData | null> {
  try {
    const res = await fetch(
      `${process.env.NEXT_PUBLIC_API_URL_New}/event-hub/commune/${commune}`,
      {
        method: 'GET',
        headers: {
          'Content-Type': 'application/json',
        },
      }
    );
    
    if (res.status === 200) {
      const data: CommuneData = await res.json();
      return data;
    } else {
      console.error('Error fetching commune data:', res.status);
      return null;
    }
  } catch (error) {
    console.error('Error fetching commune data:', error);
    return null;
  }
}
export async function getEventHubDataWithParams(params: {
  city_id?: string;
  categories?: string;
  start_date?: string;
  end_date?: string;
}): Promise<EventData[] | null> {
  try {
    const { 
      city_id = '13005', 
      categories = '20', 
      start_date = '', 
      end_date = '' 
    } = params;

    const url = `${process.env.NEXT_PUBLIC_API_URL_New}/events/event-hub?city_id=${city_id}&categories=${categories}&start_date=${start_date}&end_date=${end_date}`;

    const response = await fetch(url, {
      method: 'GET',
      headers: {
        'Content-Type': 'application/json',
      },
    });

    if (response.status === 200) {
      const data: EventData[] = await response.json();
      return data;
    } else {
      console.error('Error fetching event hub data:', response.status);
      return null;
    }
  } catch (error) {
    console.error('Error fetching event hub data:', error);
    return null;
  }
}

export async function getCityHubAdvert(slug: string): Promise<any> {
  try {
    const url = `${process.env.NEXT_PUBLIC_API_URL_New}/cityhub-campaigns/fetch-city-hub-advert?slug=${slug}`;
    
    const response = await fetch(url, {
      method: 'GET',
      headers: {
        'Content-Type': 'application/json',
      },
    });

    if (response.status === 200) {
      const data = await response.json();
      return data.data;
    } else {
      console.error('Error fetching city hub advert:', response.status);
      return null;
    }
  } catch (error) {
    console.error('Error fetching city hub advert:', error);
    return null;
  }
}

export async function getCityHubSelectedEvents(params: {
  city_id?: string;
  categories?: string;
  start_date?: string;
  end_date?: string;
}): Promise<any> {
  try {
    const { 
      city_id = '13005', 
      categories = '', 
      start_date = '', 
      end_date = '' 
    } = params;

    const url = `${process.env.NEXT_PUBLIC_API_URL_New}/events/city-hub-selected-events?city_id=${city_id}&categories=${categories}&start_date=${start_date}&end_date=${end_date}`;
    
    const response = await fetch(url, {
      method: 'GET',
      headers: {
        'Content-Type': 'application/json',
      },
    });

    if (response.status === 200) {
      const data = await response.json();
      return data;
    } else {
      console.error('Error fetching city hub selected events:', response.status);
      return null;
    }
  } catch (error) {
    console.error('Error fetching city hub selected events:', error);
    return null;
  }
}