import NextAuth from "next-auth"
import type { NextAuthOptions } from "next-auth";
import CredentialsProvider from "next-auth/providers/credentials";

export const authOptions: NextAuthOptions = {
    secret: process.env.NextAuth_SECRET,
    // Configure one or more authentication providers
    providers: [       
        CredentialsProvider({
            name: "Sign in",
            credentials: {
              email: { label: "Email", type: "email", placeholder: "example@example.com", },
              password: { label: "Password", type: "password" },
              language: { label: "Language", type: "string" },
            },
            async authorize(credentials) {
                if (!credentials?.email || !credentials.password) {
                    return null;
                  }
               
                const res = await fetch(process.env.API_URL+'/login-users', {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json",
                    },
                    body: JSON.stringify({
                        email: credentials.email,
                        password: credentials.password,
                        language: credentials.language
                    }),
                });
                const user = await res.json();
                if (user.status == 200) {
                  // return Promise.resolve({ ...user });
                  // return user;
                    return {
                        id: user.user_id,
                        randomKey:  user.jwt,
                        photo:user.photo,
                        user_avtar:user.avtar_text,
                        name:user.name,
                        email:user.email
                      };

                }else{
                  throw new Error(user.message);
                }               
                
                return null;
            },
        }),
        // ...add more providers here
    ],
    callbacks: {
        session: ({ session, token }) => {
            return {
              ...session,
              ...token,
              user: {
                ...session.user,
                id: token.id,
                randomKey: token.randomKey,
                photo:token.photo,
                user_avtar:token.avtar_text,
                name:token.name,
                email:token.email
              },
            };
          },
        jwt: ({ token, user }) => {
            if (user) {
              const u = user as unknown as any;
              
              return {
                ...token,
                id: u.id,
                randomKey: u.randomKey,
                photo:u.photo,
                user_avtar:u.avtar_text,
                name:u.name,
                email:u.email
              };
            }
            return token;
          }
    },
    pages: {
        signIn: '/login',
    }
}
// export default NextAuth(authOptions)