export async function loginUser(email: string, password: string, language: string = "en"): Promise<any> {
  const loginData = {
    email: email,
    password: password,
    language: language
  };

  try {
    const res = await fetch(
      process.env.NEXT_PUBLIC_API_URL_New + "/auth/login",
      {
        method: "POST",
        body: JSON.stringify(loginData),
        headers: {
          "Content-Type": "application/json",
        },
      }
    );
    
    const data = await res.json();

    if (res.ok && data.status === 200) {
      return data; // Return the full response data which likely includes the token
    } else {
      throw new Error(data.message || "Login failed");
    }
  } catch (error) {
    console.error("Login error:", error);
    throw error;
  }
}
