import axios from "axios";
import Cookies from "js-cookie";

export async function getAllEvents() {
  const res = await fetch(process.env.API_URL + "/get-events");

  const posts = await res.json();

  return posts;
}
export async function getUserInfo(user_id: number, token: any): Promise<any> {
  const formValues = {
    user_id: user_id,
  };

  const res = await fetch(
    process.env.NEXT_PUBLIC_API_URL + "/get-single-user-information",
    {
      method: "POST",
      body: JSON.stringify(formValues),
      headers: {
        "Content-Type": "application/json",
        Authorization: "Bearer " + token,
      },
    }
  );
  const data = await res.json();

  if (data.status == 200) {
    return data.getUserInfo;
  } else {
    return null;
  }
}
export async function getOnlineAndPastEvent(
  user_id: any,
  token: any
): Promise<any> {
  try {
    const formValues = {
      user_id: user_id,
    };
    const res = await fetch(
      process.env.NEXT_PUBLIC_API_URL + "/get-online-and-past-event",
      {
        method: "POST",
        body: JSON.stringify(formValues),
        headers: {
          "Content-Type": "application/json",
        },
      }
    );
    const data = await res.json();

    if (data.status == 200) {
      return data.event_details;
    } else {
      return data.event_details;
    }
  } catch (error) {
    console.error("Error fetching event data:", error);
    throw error; // Rethrow the error for the caller to handle
  }
}
export async function getEventData(
  slug: string,
  user_id: number
): Promise<any> {
  try {
    const apiUrl = `${process.env.NEXT_PUBLIC_API_URL}/get-single-event-by-id?event_id=${slug}&user_id=${user_id}`;

    const res = await fetch(apiUrl);

    if (!res.ok) {
      // Handle the case where the API request was not successful
      throw new Error(`Failed to fetch event data. Status: ${res.status}`);
    }

    const data = await res.json();
    return data;
  } catch (error) {
    console.error("Error fetching event data:", error);
    throw error; // Rethrow the error for the caller to handle
  }
}

export async function getSingleEventdataNew(slug: string): Promise<any> {
  let searchLocation: string | null = "";
  if (typeof window !== "undefined") {
    searchLocation = localStorage.getItem("searchLocation");
  }
  try {
    const apiUrl = `${process.env.NEXT_PUBLIC_API_URL}/get-single-event?event_slug=${slug}&searchLocation=${searchLocation}`;
    const res = await fetch(apiUrl);
    // console.log(res, "res of data");
    if (!res.ok) {
      // Handle the case where the API request was not successful
      throw new Error(`Failed to fetch event data. Status: ${res.status}`);
    }
    const data = await res.json();
    return data;
  } catch (error) {
    console.error("Error fetching event data:", error);
    throw error; // Rethrow the error for the caller to handle
  }
}
export async function getSingleEventdataNew1(
  slug: string,
  language: string
): Promise<any> {
  try {
    console.log("event called");
    const apiUrl = `${process.env.NEXT_PUBLIC_API_URL_New}/events/get-single-event?event_slug=${slug}&language=${language}`;
    const res = await fetch(apiUrl);
    // console.log(res, "res of data");
    if (!res.ok) {
      // Handle the case where the API request was not successful
      throw new Error(`Failed to fetch event data. Status: ${res.status}`);
    }
    console.log(new Date().getMilliseconds());
    const data = await res.json();
    return data;
  } catch (error) {
    console.error("Error fetching event data:", error);
    throw error; // Rethrow the error for the caller to handle
  }
}
export async function getSingleEventdata(
  slug: string,
  ipaddress: string
): Promise<any> {
  let searchLocation: string | null = "";
  let searchLat: string | null = "";
  let searchLng: string | null = "";
  let language = Cookies.get("NEXT_LOCALE");
  if (typeof window !== "undefined") {
    searchLocation = localStorage.getItem("searchLocation");
    searchLat = localStorage.getItem("searchLat");
    searchLng = localStorage.getItem("searchLng");
  }
  try {
    const apiUrl = `${process.env.NEXT_PUBLIC_API_URL}/get-single-event?event_slug=${slug}&searchLocation=${searchLocation}&ip_address=${ipaddress}&userLat=${searchLat}&userLng=${searchLng}&language=${language}`;
    const res = await fetch(apiUrl);
    // console.log(res);
    if (!res.ok) {
      // Handle the case where the API request was not successful
      throw new Error(`Failed to fetch event data. Status: ${res.status}`);
    }
    const data = await res.json();
    return data;
  } catch (error) {
    console.error("Error fetching event data:", error);
    throw error; // Rethrow the error for the caller to handle
  }
}
export async function getEventQuestionData(event_id: number, token: any) {
  const formValues = {
    event_id: event_id,
  };
  const res = await fetch(
    process.env.NEXT_PUBLIC_API_URL + "/get-questions-by-events",
    {
      method: "POST",
      body: JSON.stringify(formValues),
      headers: {
        "Content-Type": "application/json",
        Authorization: "Bearer " + token,
      },
    }
  );
  const data = await res.json();
  return data;
}

export async function getQuetionByEventOrganizer(user_id: number, token: any) {
  const formValues = {
    user_id: user_id,
  };
  const res = await fetch(
    process.env.NEXT_PUBLIC_API_URL + "/get-question-by-event-organizer",
    {
      method: "POST",
      body: JSON.stringify(formValues),
      headers: {
        "Content-Type": "application/json",
        Authorization: "Bearer " + token,
      },
    }
  );
  const data = await res.json();
  return data;
}
export async function eventLikeByUser(
  event_id: number,
  user_id: any,
  token: any
): Promise<any> {
  const formValues = {
    event_id: event_id,
    user_id: user_id,
  };
  const res = await fetch(
    process.env.NEXT_PUBLIC_API_URL + "/event-like-dislike",
    {
      method: "POST",
      body: JSON.stringify(formValues),
      headers: {
        "Content-Type": "application/json",
        Authorization: "Bearer " + token,
      },
    }
  );
  const data = await res.json();

  if (data.status == 200) {
    return data;
  } else {
    return null;
  }
}
export async function eventParticiaptedByUser(
  event_id: number,
  user_id: any,
  token: any,
  language: any
): Promise<any> {
  const formValues = {
    event_id: event_id,
    user_id: user_id,
    language: language,
  };
  const res = await fetch(
    process.env.NEXT_PUBLIC_API_URL + "/participate-in-events",
    {
      method: "POST",
      body: JSON.stringify(formValues),
      headers: {
        "Content-Type": "application/json",
        Authorization: "Bearer " + token,
      },
    }
  );
  const data = await res.json();
  return data;
}

//  event may go call

export async function eventMayGoByUser(
  event_id: number,
  user_id: any,
  token: any
): Promise<any> {
  const formValues = {
    event_id: event_id,
    user_id: user_id,
  };
  const res = await fetch(process.env.NEXT_PUBLIC_API_URL + "/may-go-events", {
    method: "POST",
    body: JSON.stringify(formValues),
    headers: {
      "Content-Type": "application/json",
      Authorization: "Bearer " + token,
    },
  });
  const data = await res.json();
  return data.status;
}
export async function getLocationData() {
  const res = await fetch(process.env.API_URL + "/get-state-with-country");
  const data = await res.json();
  // if(data.status == 200){
  return data;
  // }
  // return null;
}

export async function getLoactionSearch(search_keyword: any) {
  const res = await fetch(
    process.env.NEXT_PUBLIC_API_URL +
      "/get-state-with-country?search_keyword=" +
      search_keyword
  );
  const data = await res.json();

  if (data.status == 200) {
    return data.getResult;
  } else {
    return 0;
  }
  // return data.getResult;
}

export async function getVenueLoactionSearch(
  search_keyword: string,
  city_name: string,
  post_code: string
) {
  const apiKey =
    "qoweurqowerupqoweruqwoeriqasdfasdlfjqwoweirqwerqwerqweiruoqwerqower";
  const res = await fetch(
    process.env.NEXT_PUBLIC_ADDRESSES_API_URL + "/addresses",
    {
      method: "POST",
      body: JSON.stringify({ keyword: search_keyword, city_name, post_code }),
      headers: {
        "Content-Type": "application/json",
        "x-api-key": apiKey,
      },
    }
  );
  const data = await res.json();
  if (data.length >= 1) {
    return data;
  } else {
    return 0;
  }
  // return data.getResult;
}

export async function getVenueCommuneSearch(
  communeName: any,
  postal_code: any
) {
  const apiKey =
    "qoweurqowerupqoweruqwoeriqasdfasdlfjqwoweirqwerqwerqweiruoqwerqower";
  const res = await fetch(
    process.env.NEXT_PUBLIC_ADDRESSES_API_URL + "/cities",
    {
      method: "POST",
      body: JSON.stringify({ name: communeName, post_code: postal_code }),
      headers: {
        "Content-Type": "application/json",
        "x-api-key": apiKey,
      },
    }
  );
  const data = await res.json();
  if (data.length >= 1) {
    return data;
  } else {
    return 0;
  }
  // return data.getResult;
}

export async function getRandomEvents() {
  const res = await fetch(
    process.env.NEXT_PUBLIC_API_URL + "/get-randon-event"
  );
  const data = await res.json();
  if (data.status == 200) {
    return data.eventList;
  } else {
    return 0;
  }
}

export async function getCategoryList(lang: any) {
  const res = await fetch(
    process.env.NEXT_PUBLIC_API_URL + "/get-category?language=" + "fr"
  );
  const data = await res.json();
  if (data.status == 200) {
    return data.categoryList;
  } else {
    return 0;
  }
}
export async function getCategoriesDetails(
  categoryIds: number[],
  lang: string
) {
  try {
    const idsString = categoryIds.join(",");
    const url = `${process.env.NEXT_PUBLIC_API_URL_New}/categories/categories-details/${idsString}?lang=${lang}`;

    const res = await fetch(url);

    if (!res.ok) {
      throw new Error(`HTTP error! status: ${res.status}`);
    }

    const data = await res.json();
    return data;
  } catch (error) {
    console.error("Error fetching category details:", error);
    return null;
  }
}

export async function getEventsListNearYou(
  lang: any,
  commune: any,
  postal_code: any,
  lat: any,
  lng: any
) {
  const currentDate = new Date();

  // Create a second date by adding 7 days
  const nextWeekDate = new Date(currentDate);
  nextWeekDate.setDate(currentDate.getDate() + 30);

  // Format the dates in the format YYYY-MM-DD
  const formattedCurrentDate = currentDate.toISOString().split("T")[0];
  const formattedNextWeekDate = nextWeekDate.toISOString().split("T")[0];

  // let lat = localStorage.getItem("searchLat");
  // let lng = localStorage.getItem("searchLng");

  const searchLocation = localStorage.getItem("searchLocation");
  const formValues = {
    town_or_city: commune,
    start_date: formattedCurrentDate,
    end_date: formattedNextWeekDate,
    distance: 30,
    category_id: "",
    event_cost: "",
    sorting: "",
    event_top_id: null,
    postalCode: postal_code,
    userLat: lat,
    userLng: lng,
    searchLocation: searchLocation,
    language: lang,
  };

  const res = await fetch(
    process.env.NEXT_PUBLIC_API_URL + "/ajax-event-filter",
    {
      method: "POST",
      body: JSON.stringify(formValues),
      headers: {
        "Content-Type": "application/json",
      },
    }
  );
  // console.log("lat : ", lat, " lng : ", lng);
  // console.log("res : ", res.json());
  const data = await res.json();

  // if(data.status==200){
  //   return data;
  // }else{
  return data.filterResult;
  // }
  // if(data.status==200){
  //   return data.categoryList;
  // }else{
  //   return 0;
  // }
}

export async function newGetEventsListNearYou(
  currentEventId: string,
  postalCode: string,
  distance: string | number
) {
  console.log(
    process?.env?.NEXT_PUBLIC_API_URL_New,
    "process?.env?.NEXT_PUBLIC_API_URL_New"
  );
  // Create URL with base path
  const url = new URL(`${process?.env?.NEXT_PUBLIC_API_URL_New}/events/nearby`);
  console.log(url, "url");
  // Add query parameters
  url.searchParams.append("currentEventId", currentEventId);
  url.searchParams.append("postalCode", postalCode);
  url.searchParams.append("distance", distance.toString());

  const res = await fetch(url, {
    method: "GET",
    headers: {
      "Content-Type": "application/json",
    },
  });

  if (!res.ok) {
    throw new Error(`Failed to fetch events: ${res.status}`);
  }

  const data = await res.json();
  return data;
}

export async function getPageContent(pageType: any) {
  const lang = Cookies.get("NEXT_LOCALE");
  const res = await fetch(
    `${process.env.NEXT_PUBLIC_API_URL}/get-page-content-by-page-type?language=${lang}&page_type=${pageType}`
  );
  const data = await res.json();
  if (data.status == 200) {
    return data.pageInfo;
  } else {
    return 0;
  }
}

export async function getFaqList() {
  const res = await fetch(`${process.env.NEXT_PUBLIC_API_URL}/get-faq-list`);

  const data = await res.json();
  if (data.status == 200) {
    return data.faqList;
  } else {
    return 0;
  }
}

export async function getEventByPostalCode() {
  let searchLocation: string | null = "";
  let searchLat: string | null = "";
  let searchLng: string | null = "";
  if (typeof window !== "undefined") {
    searchLocation = localStorage.getItem("searchLocation");
    searchLat = localStorage.getItem("searchLat");
    searchLng = localStorage.getItem("searchLng");
  }
  const formValues = {
    searchLocation: searchLocation,
    searchLat: searchLat,
    searchLng: searchLng,
  };
  const res = await fetch(
    process.env.NEXT_PUBLIC_API_URL + "/get-event-by-postal-code",
    {
      method: "POST",
      body: JSON.stringify(formValues),
      headers: {
        "Content-Type": "application/json",
      },
    }
  );
  const data = await res.json();
  if (data.status == 200) {
    return data.eventData;
  } else {
    return 0;
  }
}
export async function getEventAjaxFilter(
  location: any,
  start_date: any,
  end_date: any,
  distance: any,
  cat: any,
  price: any,
  sort: any,
  top: any,
  offset: number,
  language: string = "fr"
) {
  let postal_code: any;
  if (location == "All") {
    postal_code = localStorage.getItem("userPostalCode");
  }
  let lat: any;
  let lng: any;
  if (distance != "All of France") {
    lat = localStorage.getItem("searchLat");
    lng = localStorage.getItem("searchLng");
  } else {
    lat = localStorage.getItem("searchLat");
    lng = localStorage.getItem("searchLng");
  }
  const searchLocation = localStorage.getItem("searchLocation");
  // let language = Cookies.get("NEXT_LOCALE");

  const formValues = {
    town_or_city: location,
    start_date: start_date,
    end_date: end_date,
    distance: distance,
    category_id: cat,
    event_cost: price,
    sorting: sort,
    event_top_id: top,
    postalCode: postal_code,
    userLat: lat,
    userLng: lng,
    offset: offset,
    searchLocation: searchLocation,
    language: language,
  };

  // console.log(formValues);

  // console.log(process.env.NEXT_PUBLIC_API_URL+ '/ajax-event-filter')
  // console.log(formValues)
  const res = await fetch(
    process.env.NEXT_PUBLIC_API_URL + "/ajax-event-filter",
    {
      method: "POST",
      body: JSON.stringify(formValues),
      headers: {
        "Content-Type": "application/json",
      },
    }
  );

  const data = await res.json();
  // if(data.status==200){
  //   return data;
  // }else{
  return data;
  // }
}

export async function getEventListByStatus(
  user_id: number,
  event_status: number,
  token: any
) {
  const formValues = {
    user_id: user_id,
    event_status: event_status,
  };
  const res = await fetch(
    process.env.NEXT_PUBLIC_API_URL + "/get-organizer-event-list-by-status",
    {
      method: "POST",
      body: JSON.stringify(formValues),
      headers: {
        "Content-Type": "application/json",
        Authorization: "Bearer " + token,
      },
    }
  );
  const data = await res.json();
  if (data.status == 200) {
    return data.eventList;
  } else {
    return 0;
  }
}

export async function getPastEventList(user_id: number, token: any) {
  const formValues = {
    user_id: user_id,
  };
  const res = await fetch(
    process.env.NEXT_PUBLIC_API_URL + "/get-organizer-past-events",
    {
      method: "POST",
      body: JSON.stringify(formValues),
      headers: {
        "Content-Type": "application/json",
        Authorization: "Bearer " + token,
      },
    }
  );
  const data = await res.json();
  if (data.status == 200) {
    return data.eventList;
  } else {
    return 0;
  }
}

// getpastData
export async function getPastData(slug: any) {
  const res = await fetch(
    process.env.NEXT_PUBLIC_API_URL + "/get-single-event?event_slug=" + slug
  );
  const data = await res.json();
  // if(data.status == 200){
  return data;
  // }
  // return null;
}

export async function viewStatisticsData(event_id: number, token: any) {
  const formValues = {
    event_id: event_id,
  };
  const res = await fetch(
    process.env.NEXT_PUBLIC_API_URL + "/get-statistics-data-by-event",
    {
      method: "POST",
      body: JSON.stringify(formValues),
      headers: {
        "Content-Type": "application/json",
        Authorization: "Bearer " + token,
      },
    }
  );
  const data = await res.json();
  if (data.status == 200) {
    return data.participatedUser;
  } else {
    return 0;
  }
}

export async function getEventByOrgnisation(user_id: any): Promise<any> {
  let searchLocation: string | null = "";
  let userLat: string | null = "";
  let userLng: string | null = "";
  if (typeof window !== "undefined") {
    searchLocation = localStorage.getItem("searchLocation");
    userLat = localStorage.getItem("searchLat");
    userLng = localStorage.getItem("searchLng");
  }
  const language = Cookies.get("NEXT_LOCALE");
  const formValues = {
    user_id: user_id,
    searchLocation: searchLocation,
    userLat: userLat,
    userLng: userLng,
    language: language,
  };
  const res = await fetch(
    process.env.NEXT_PUBLIC_API_URL + "/get-event-by-organisation",
    {
      method: "POST",
      body: JSON.stringify(formValues),
      headers: {
        "Content-Type": "application/json",
      },
    }
  );
  const data = await res.json();
  return data;
}

export async function getEventByTitleSearch(
  name: any,
  page: number
): Promise<any> {
  let searchLocation: string | null = "";
  let userLat: string | null = "";
  let userLng: string | null = "";
  if (typeof window !== "undefined") {
    searchLocation = localStorage.getItem("searchLocation");
    userLat = localStorage.getItem("searchLat");
    userLng = localStorage.getItem("searchLng");
  }
  const language = Cookies.get("NEXT_LOCALE");
  const formValues = {
    event_title: name,
    searchLocation: searchLocation,
    offset: 0,
    userLat: userLat,
    userLng: userLng,
    language: language,
  };
  const res = await fetch(process.env.NEXT_PUBLIC_API_URL + "/event-list", {
    method: "POST",
    body: JSON.stringify(formValues),
    headers: {
      "Content-Type": "application/json",
    },
  });
  const data = await res.json();
  if (data.status == 200) {
    return data;
  } else {
    return 0;
  }
}

export async function searchEventByTitle(name: any): Promise<any> {
  let searchLocation: string | null = "";
  if (typeof window !== "undefined") {
    searchLocation = localStorage.getItem("searchLocation");
  }
  const formValues = {
    organizer_name: name,
    searchLocation: searchLocation,
  };
  const res = await fetch(process.env.NEXT_PUBLIC_API_URL + "/organizer-list", {
    method: "POST",
    body: JSON.stringify(formValues),
    headers: {
      "Content-Type": "application/json",
    },
  });
  const data = await res.json();
  if (data.status == 200) {
    return data.getResult;
  } else {
    return 0;
  }
}

export async function userTokenVerify(code: any, language: any) {
  const formValues = {
    token: code,
    language: language,
  };
  const res = await fetch(
    process.env.NEXT_PUBLIC_API_URL + "/email-verification",
    {
      method: "POST",
      body: JSON.stringify(formValues),
      headers: {
        "Content-Type": "application/json",
      },
    }
  );
  const data = await res.json();
  return data;
  // if(data.status==200){
  //   return data.eventData;
  // }else{
  //   return data.message;
  // }
}

export async function getIPLocation() {
  try {
    const response = await fetch("https://ipinfo.io/json?token=b22c8df0eb5610");

    const data = await response.json();
    return {
      ip: data.ip,
      city: data.city,
      region: data.region,
      country: data.country,
      loc: data.loc,
    };
  } catch (error) {
    console.error("Error getting IP location:", error);
    return {
      ip: "0.0.0.0",
    };
  }
}
export async function updateEventCount(params: {
  event_id: string | number;
  user_id?: string | number; // Made optional with default value
  ip_address: string;
  city: string;
  region: string;
}) {
  try {
    const { event_id, user_id = 0, ip_address, city, region } = params;

    // Construct URL using environment variable
    const apiUrl = `${process.env.NEXT_PUBLIC_API_URL_New}/event-counts/update_event_count?event_id=${event_id}&user_id=${user_id}&ip_address=${ip_address}&city=${city}&region=${region}`;

    const response = await fetch(apiUrl, {
      method: "POST",
      headers: {
        Accept: "application/json",
        // Add any authentication headers if needed
      },
      cache: "no-store", // Prevent caching if needed
    });

    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }
    // return await response.json();
  } catch (error) {
    console.error("Error updating event count:", error);
    return {
      error: "Failed to update event count",
      details: error instanceof Error ? error.message : String(error),
    };
  }
}
export async function getNearbyEventsMap(
  latitude: number,
  longitude: number,
  distance: number = 60
) {
  try {
    const response = await fetch(
      process.env.NEXT_PUBLIC_API_URL_New +
        `/events/events-nearby-me?latitude=${latitude}&longitude=${longitude}&distance=${9000}`
    );

    if (!response.ok) {
      throw new Error(`HTTP error! status: ${response.status}`);
    }

    const data = await response.json();

    // Assuming the API returns an array of events
    return {
      success: true,
      events: data?.events || data,
      latitude,
      longitude,
      distance,
    };
  } catch (error) {
    console.error("Error fetching nearby events:", error);
    return {
      success: false,
      events: [],
      error: error instanceof Error ? error.message : "Unknown error",
      latitude,
      longitude,
      distance,
    };
  }
}
export const trackEventMapInteraction = async (eventData: any) => {
  try {
    const config = {
      method: "post",
      url: `${process.env.NEXT_PUBLIC_API_URL_New}/event-maps-tracker`,
      headers: {
        "Content-Type": "application/json",
      },
      data: JSON.stringify(eventData),
    };

    const response = await axios.request(config);
    return response.data;
  } catch (error) {
    console.error("Error tracking event:", error);
    throw error; // Re-throw to let components handle errors
  }
};
