export async function getOrganizerEventStats(
  user_id: number,
  token: any
): Promise<any> {
  const formValues = {
    user_id: user_id,
  };
  const res = await fetch(
    process.env.NEXT_PUBLIC_API_URL + "/get-organizer-event-stats",
    {
      method: "POST",
      body: JSON.stringify(formValues),
      headers: {
        "Content-Type": "application/json",
        Authorization: "Bearer " + token,
      },
    }
  );
  const data = await res.json();

  if (data.status == 200) {
    return data;
  } else {
    if (data.status == "token_expired") {
      return data.status;
    } else {
      return null;
    }
  }
}

//delete-event(event_id,token)

export async function deleteEvent(
  event_id: number,
  token: any,
  user_id: number
): Promise<any> {
  const formValues = {
    event_id: event_id,
    user_id: user_id,
  };
  const res = await fetch(process.env.NEXT_PUBLIC_API_URL + "/delete-event", {
    method: "POST",
    body: JSON.stringify(formValues),
    headers: {
      "Content-Type": "application/json",
      Authorization: "Bearer " + token,
    },
  });
  const data = await res.json();
  if (data.status == 200) {
    return data;
  } else {
    return null;
  }
}

// delete question

export async function deleteQuestion(
  question_id: number,
  token: any,
  user_id: number
): Promise<any> {
  const formValues = {
    question_id: question_id,
    user_id: user_id,
  };
  const res = await fetch(
    process.env.NEXT_PUBLIC_API_URL + "/delete-question",
    {
      method: "POST",
      body: JSON.stringify(formValues),
      headers: {
        "Content-Type": "application/json",
        Authorization: "Bearer " + token,
      },
    }
  );
  const data = await res.json();
  if (data.status == 200) {
    return data;
  } else {
    return null;
  }
}

// cancel-event (event_id,user_id,token)

export async function cancelEvent(
  event_id: number,
  user_id: number,
  token: any,
  cancel_status: number
): Promise<any> {
  const formValues = {
    event_id: event_id,
    user_id: user_id,
    cancel_status,
  };
  const res = await fetch(process.env.NEXT_PUBLIC_API_URL + "/cancel-event", {
    method: "POST",
    body: JSON.stringify(formValues),
    headers: {
      "Content-Type": "application/json",
      Authorization: "Bearer " + token,
    },
  });
  const data = await res.json();
  if (data.status == 200) {
    return data;
  } else {
    return null;
  }
}

// full-event (event_id,user_id,token)

export async function fullEvent(
  event_id: number,
  user_id: number,
  token: any
): Promise<any> {
  const formValues = {
    event_id: event_id,
    user_id: user_id,
  };
  const res = await fetch(process.env.NEXT_PUBLIC_API_URL + "/event-full", {
    method: "POST",
    body: JSON.stringify(formValues),
    headers: {
      "Content-Type": "application/json",
      Authorization: "Bearer " + token,
    },
  });
  const data = await res.json();
  if (data.status == 200) {
    return data;
  } else {
    return null;
  }
}
// deleteUserAccount

export async function deleteUserAccount(
  user_id: number,
  token: any
): Promise<any> {
  const formValues = {
    user_id: user_id,
  };
  const res = await fetch(
    process.env.NEXT_PUBLIC_API_URL + "/delete-user-profile",
    {
      method: "POST",
      body: JSON.stringify(formValues),
      headers: {
        "Content-Type": "application/json",
        Authorization: "Bearer " + token,
      },
    }
  );
  const data = await res.json();
  if (data.status == 200) {
    return data;
  } else {
    return null;
  }
}
// get single user data
export async function getSingleUserData(
  user_id: number,
  token: any
): Promise<any> {
  const formValues = {
    user_id: user_id,
  };
  const res = await fetch(
    process.env.NEXT_PUBLIC_API_URL + "/get-single-user-information",
    {
      method: "POST",
      body: JSON.stringify(formValues),
      headers: {
        "Content-Type": "application/json",
        Authorization: "Bearer " + token,
      },
    }
  );
  const data = await res.json();
  if (data.status == 200) {
    return data;
  } else {
    return null;
  }
}
