export interface EventDataInt {
  event_title: string;
  description: string;
  event_category_id: string[];
  start_date: string | null;
  end_date: string | null;
  event_venue: string;
  event_venue_lat: number | null;
  event_venue_lng: number | null;
  cover_image: string;
  postal_code: string;
  city_name: string;
  city_id: number | null;
  state_id: number | null;
  organizer_contact_number: string | null;
  reservation_requried: string;
  required_date: string | null;
  time: string | null;
  end_time: string | null;
  cost: string;
  organization: string;
  commune: string;
  website: string;
  payment_in_advance: string;
  language: string;
}
export interface Category {
  id: number;
  category_name: string;
  category_icon: string;
}
export interface EventAjaxStr {
  city: string;
  cost: string;
  country: string;
  cover_image: string;
  created_at: string;
  description: string;
  end_date: string;
  end_time: string;
  event_category_id: string;
  event_count: string;
  event_lat: string;
  event_long: string;
  event_no: string;
  event_over_several_days: string;
  event_status: string;
  event_venue: string;
  id: string;
  language: string;
  organization: string;
  organizer_contact_number: string | null;
  participate_date: string;
  postal_code: string;
  city_name: string;
  repeat_end_date: string;
  required_date: string;
  reservation_required: string;
  seo_description: string;
  seo_keyword: string;
  seo_title: string;
  slug: string;
  start_date: string;
  state: string;
  time: string;
  title: string;
  towns: string;
  updated_at: string;
  user_id: string;
  authorName: string;
  state_name: string;
  imgPath: string;
  authorImgPath: string;
  authorPhoto: string;
  participatedUserCount: string;
  mayGoCount: string;
  eventLikeCount: string;
  category_name: Array<{ cat_name: string; catIcon: string; catPath: string ;cat_id:string}>;
  likes_count: number;
  participants_count: number;
  website: string;
  liked_by_user: string;
  participant_user_id: string;
  may_go_user: string;
  participatedUserID: string;
  eventMayGoArray: string;
  previousEvents: number;
  distance: string;
  otherEvents: number;
  cancel_event: string;
  event_full: any;
  payment_in_advance: any;
  title_en: any;
  description_en: any
}
export interface CommuneData {
  id: number;
  commune_name: string;
  postal_code: string;
  commune_slug: string;
  commune_id: string;
  image1: string;
  image2: string;
  image3: string;
  tile_image: string;
  heading: string;
  subheading: string;
  description: string;
  seo_title: string;
  seo_description: string;
  seo_keywords: string[] | string; // Can be array or string based on your response
}

export interface CommuneResponse {
  status: number;
  data?: CommuneData;
  message?: string;
}

export interface EventData {
  id: number;
  title: string;
  slug: string;
  start_date: string;
  end_date: string;
  time: string;
  end_time: string;
  city_name: string;
  cover_image: string;
  latitude: string;
  longitude: string;
  postal_code: string;
  description: string;
  description_en: string;
  event_count: number;
  cost: number;
  event_category_id: string;
}