export interface Event {
  id: number;
  title: string;
  slug: string;
  start_date: string;
  end_date: string;
  time: string;
  end_time: string;
  city_name: string;
  cover_image: string;
  latitude: string;
  longitude: string;
}

export async function getEventsByCategory(
  categoryId: number |string
): Promise<Event[]> {
  const response = await fetch(
    `https://backendv2testing.eventx.fr/events/findEventsByCategory?categoryId=${categoryId}`,
    {
      next: { revalidate: 3600 }, // Revalidate every hour
    }
  );

  if (!response.ok) {
    throw new Error("Failed to fetch events");
  }

  const data = await response.json();
  return data.events;
}
export async function getEventsByCategoryNew(
  categoryId: number |string,
  language:string
): Promise<Event[]> {
  const response = await fetch(
    `https://backendv2testing.eventx.fr/events/findEventsByCategoryWithDescription?categoryId=${categoryId}&language=${language}`,
    {
      next: { revalidate: 3600 }, // Revalidate every hour
    }
  );

  if (!response.ok) {
    throw new Error("Failed to fetch events");
  }

  const data = await response.json();
  return data.events;
}
