import {withAuth} from 'next-auth/middleware';
import createIntlMiddleware from 'next-intl/middleware';
import {NextRequest} from 'next/server';
 
const locales = ['fr','en'];

const intlMiddleware = createIntlMiddleware({
  locales,
  defaultLocale: 'fr',
    localePrefix: 'as-needed',
  localeDetection: false
});
 
const authMiddleware = withAuth(
  function onSuccess(req) {
    return intlMiddleware(req);
  },
  {
    callbacks: {
      authorized: ({token}) => token != null
    },
    pages: {
      signIn: '/login'
    }
  }
);
 


export default function middleware(req: NextRequest) {
  let response = intlMiddleware(req);
 
   if (req.nextUrl.pathname.startsWith('/dashboard') || req.nextUrl.pathname.startsWith('/en/dashboard')) {
     response =  (authMiddleware as any)(req);
   }
 
   return response;
 }
 
export const config = {
  // Skip all paths that should not be internationalized
  matcher: ['/((?!api|_next|.*\\..*).*)']
};